foreach (Process p in Process.GetProcesses()
    .Where(pr => pr.ProcessName.StartsWith("L")) // Opcjonalny filtr zawężający
	)
	using (p)
	{
		Console.WriteLine (p.ProcessName);
		Console.WriteLine ("   PID:      " + p.Id);
		Console.WriteLine ("   Memory:   " + p.WorkingSet64);
		Console.WriteLine ("   Threads:  " + p.Threads.Count);
		EnumerateThreads(p);
	}

void EnumerateThreads (Process p)
{
	try
	{
		foreach (ProcessThread pt in p.Threads)
		{
			Console.WriteLine (pt.Id);
			Console.WriteLine ("   State:    " + pt.ThreadState);
			Console.WriteLine ("   Priority: " + pt.PriorityLevel);
			Console.WriteLine ("   Started:  " + pt.StartTime);
			Console.WriteLine ("   CPU time: " + pt.TotalProcessorTime);
		}
	}
	catch (InvalidOperationException ex) // Proces może zniknąć podczas enumeracji wątków
	{
		Console.WriteLine ($"Wyjątek: {ex.Message}");
	}
	catch (Win32Exception ex) // Możemy nie mieć dostępu
	{
		Console.WriteLine ($"Wyjątek: {ex.Message}");
	}
}